/*
  T64 TapeMaker
  Creates a T64 file and imports C64 files
  T64 is a standard C64S tape image
  C64 file must be in standard PRG format:
    2 bytes start address, the other bytes file contents
*/

#include <io.h>
#include <dos.h>
#include <string.h>
#include <fcntl.h>

#define  NEWSIZE  30
#define  BUFSIZE  16384

typedef struct
{
  char
    text [32];
  int
    version, entries, used, xxx;
  char
    name [24];
}
  HEADER;

typedef struct
{
  unsigned char
    etype, ctype;
  unsigned int
    start, end, xxx1;
  unsigned long
    fpos, xxx2;
  char
    name [16];
}
  ENTRY;

char
	buffer [BUFSIZE];

void main( int argc, char **argv )
{
  char
		name [256];
	HEADER
		header =
		{
			"C64 tape image file",
			0x100,
			NEWSIZE,
			0, 0,
			"IMPORTED FILES          "
		};
	ENTRY
		entry =
		{
			0, 0,
			0, 0, 0,
			0, 0,
			""
		};
	int
		t, f, n, nf, r;
	unsigned long
		pos;

  if( argc == 1 )
  {
		printf( "Usage: MAKETAPE t64name [file1 [file2 ...]]\n" );
		return;
  }
  strcpy( name, argv[1] );
	strcat( name, ".T64" );
	if( (t = _open( name, O_RDWR )) < 0 )
	{
		if( (t = _creat( name, FA_ARCH )) < 0 )
		{
			printf( "Can't create file: %s\n", name );
			return;
		}
		printf( "Creating file: %s\n", name );
		_write( t, &header, sizeof( header ));
		for( n = nf = 0; n < NEWSIZE; n++ )
			_write( t, &entry, sizeof( entry ));
	}
	else
	{
		printf( "Openning file: %s\n", name );
		_read( t, &header, sizeof( header ));
		_read( t, &entry, sizeof( entry ));
		for( n = 0; entry.etype != 0 && n < header.entries; n++ )
		{
			_read( t, &entry, sizeof( entry ));
		}
		nf = n;
	}
	for( n = 2; n < argc && nf < header.entries; n++ )
	{
		if( (f = _open( argv[n], O_RDONLY )) < 0 )
		{
			printf( "Can't open: %s\n", argv[n] );
		}
		else
		{
			printf( "Importing file: %s\n", argv[n] );
			_read( f, &entry.start, 2 );
			entry.end = entry.start;
			entry.etype = 1;
			entry.ctype = 1;
			entry.fpos = filelength( t );
			lseek( t, entry.fpos, SEEK_SET );
			for( r = _read( f, buffer, BUFSIZE ); r > 0;
				r = _read( f, buffer, BUFSIZE ))
			{
				_write( t, buffer, r );
				entry.end += r;
			}
			_close( f );
			strcpy( name, argv[n] );
			strupr( name );
			strcat( name, "                " );
			strncpy( entry.name, name, 16 );
			lseek( t, sizeof( header ) + nf * sizeof( entry ), SEEK_SET );
			_write( t, &entry, sizeof( entry ));
			nf++;
		}
	}
	header.used = nf;
	lseek( t, 0, SEEK_SET );
	_write( t, &header, sizeof( header ));
	_close( t );
	printf( "O.K.\n" );
}



