    REM  Lister & List-All by Jim Butterfield
    '
    REM  major mods by Joe Griffin
    '
    DEFINT A-Z

    DECLARE FUNCTION PetConv$ (in$)

    REM  version 5.u pet for fx-80/cbm all systems
    REM              assumed f rom contains lee allen's ascii output mod
    REM  version 6    23/jun/85 - for any disk drive
    REM  version 6.1  13/jul/86 - header bug fix for cbm printer
    REM  version 7.1   8/aug/87 - c-128,plus-4 and superbase added
    REM  version 7.2   4/oct/87 - minor tidy up of initial screen
    REM  version 7.3  10/oct/87 - superbase 128 tokens added
    REM  version 8.0   1/jan/88 - override of m/c type added
    REM                           ascii conversion on any m/c
    REM  version 8.1  17/apr/88 - c-128 also has +4 extra tokens
    REM  version 8.2   4/jul/88 - correction of printing on cbm
    REM  version 9.0  10/sep/88 - version for c-128
    REM  version 9.1   6/nov/88 - recognition of 1581 drive
    REM  version 9.11 23/dec/88 - allow epson to use conversion for set-up
    REM  version 9.12  1/may/89 - cbm serial printer, fix 1541 ident
    REM  version 9.13 29/sep/89 - epson serial printer
    REM  version 9.14 22/oct/89 - epson serial printer with in-built conversion
    REM  version 9.15 24/mar/90 - cmd hard drive recognised
    REM  version 9.2  26/apr/90 - basic 8 tokens added
    REM  version 9.21 27/aug/90 - general cmd hd recognition
    REM  version 9.22 22/oct/90 - drop title line for file copy
    REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    '
    ' Version 10.01 - 26/Oct/92 - Version for PC!
    '
    REM pet ascii to standard ascii
  
    DIM SHARED t$(255)
    :
    FOR i = 0 TO 64: t$(i) = CHR$(i): NEXT
    FOR i = 65 TO 90: t$(i) = CHR$(i + 32): NEXT
    FOR i = 91 TO 95: t$(i) = CHR$(i): NEXT
    FOR i = 96 TO 127: t$(i) = t$(i - 64): NEXT
    FOR i = 128 TO 192: t$(i) = t$(i - 128): NEXT
    FOR i = 193 TO 223: t$(i) = CHR$(i - 128): NEXT
    FOR i = 224 TO 255: t$(i) = t$(i - 64): NEXT
   
    COLOR 1, 7
    CLS
    PRINT ""
    PRINT "      Lister    by: Jim Butterfield"
    PRINT "      ~~~~~~"
    PRINT "      Modified by Joe Griffin (ICPUG)"
    PRINT
    PRINT "      Version 10.01 - 26 Oct 1992"
    PRINT
    PRINT "      Should Identify ALL CBM 8-bit CPU Systems"
    PRINT ""
    PRINT "      Reads BASIC & SuperBase files"
    REM
    REM control codes
    REM
    DATA exp.char,underline,stop,char(4),white,char(6),bell,lock
    DATA tab,line.feed,lock,form.feed,return,text,set.top,char(16)
    DATA down,rvs,home,del,d.line,er.end,char(23),tab.set
    DATA scroll.up,char(26),escape,red,right,green,blue,space
    DATA exp.off,uline.off,run,char(132),f1,f3,sh.bell,f7
    DATA togl.tab,f4,f6,f8,sh.ret,graphic,set.botm,black
    DATA up,rvs.off,clear,insert,ins.line,er.begin,d.grey,m.grey
    DATA scroll.down,l.blue,l.grey,purple,left,yellow,cyan,sh.space
    REM
    DIM a$(64), k$(128), k4$(10), k8$(90), kb$(127)
   
    qt$ = CHR$(34)
   
    FOR j = 1 TO 64: READ a$(j): NEXT j
    REM
    REM tokens (all machines)
    REM
    DATA end,for,next,data,input#,input,dim,read,let,goto,run,if,restore,gosub
    DATA return,rem,stop,on,wait,load,save,verify,def,poke,print#,print,cont
    DATA list,clr,cmd,sys,open,close,get,new,tab(,to,fn,spc(,then,not,step
    DATA +,-,*,/,^,and,or,>,=,<,sgn,int,abs,usr,fre,pos,sqr,rnd,log,exp,cos
    DATA sin,tan,atn,peek,len,str$,val,asc,chr$,left$,right$,mid$,go
    REM
    REM basic 4 tokens - nb c-128 has these at a different place!!!
    REM
    DATA concat,dopen,dclose,record,header,collect,backup,copy,append,dsave
    DATA dload,catalog,rename,scratch,directory
    REM
    FOR j = 0 TO 90: READ k$(j): NEXT j
730 sf = 0
    PRINT
    INPUT " Name of Program file "; g$

780 IF RIGHT$(g$, 2) = ".p" THEN sf = 1: GOTO 810
    ON ERROR GOTO 2530: OPEN g$ FOR INPUT AS #1: IF rt = 0 THEN GOTO 850
    CLOSE 1: sf = 1: REM try superbase file
810 OPEN g$ FOR INPUT AS #1: IF rt = 2 THEN 730
    CLOSE 1
    OPEN g$ FOR BINARY AS #1
    a$ = INPUT$(1, #1): b$ = INPUT$(1, #1)
    c$ = INPUT$(1, #1): c$ = CHR$((ASC(c$) AND 15))
    IF (a$ + b$ + c$) <> ("sb" + CHR$(1)) THEN PRINT : PRINT "Not a Superbase File!": GOTO 730
    GOTO 980
850
    CLOSE 1: ' We need it open as Binary!
    OPEN g$ FOR BINARY AS #1
    ON ERROR GOTO 0
    a$ = INPUT$(1, #1): b$ = INPUT$(1, #1)
    sa = ASC(a$) + 256 * ASC(b$)
    PRINT : PRINT " Starting Address :"; sa; "   Hex $"; : GOSUB 2650: PRINT
900 IF sa <> 3 AND sa < 1025 THEN x$ = INPUT$(1, #1): sa = sa + 1: GOTO 900
    IF sa = 1025 THEN a$ = CHR$(1): b$ = CHR$(4)
    rc = 0: GOSUB 2670: REM identify basic
    IF rc = 1 THEN 730: REM not basic
    PRINT " Original Machine was (probably) "; ty$
    PRINT
    DO
        INPUT " Is This Correct (y/n) "; x$
        LOCATE CSRLIN - 1
    LOOP UNTIL x$ <> ""
    IF ASC(UCASE$(x$)) = 89 THEN 1000
    GOSUB 4050: GOSUB 2710: GOTO 1000
980
    ON ERROR GOTO 0
    PRINT : PRINT "     SuperBase File "; qt$; g$; qt$; " found"
    GOSUB 3700: REM get additional tokens
1000 PRINT : PRINT : INPUT " Line Number Range  [mmm - nnn]"; z$
     IF z$ = "" THEN z$ = "-"
     l0& = 0: l1& = 0: l2& = 65535
     FOR j = 1 TO LEN(z$): y$ = MID$(z$, j, 1)
     y = ASC(y$): IF y >= 48 AND y <= 57 GOTO 1060
     IF y = 32 GOTO 1060
     l0& = j: IF y <> 45 GOTO 1110
1060 NEXT j
     IF l0& < LEN(z$) THEN l2& = VAL(MID$(z$, l0& + 1)): IF l2& = 0 THEN l2& = 65535
     IF l0& > 1 THEN l1& = VAL(z$)
     IF l0& = 0 THEN l1& = l2&
     p1$ = "[": p2$ = "]": pi$ = "pi": pc = 75: ps = 0
1110
1180 pp = 8: PRINT
    DO
        INPUT " Name of Output file "; of$
        LOCATE CSRLIN - 1
    LOOP UNTIL of$ <> ""
1220 OPEN of$ FOR OUTPUT AS #2
     t7 = 1
1280 f$ = p1$
     PRINT
     INPUT " Output Line Length "; j
1330 l9 = j
     REM new line
1360 GOSUB 2290: q = 0: da = 0: sb = 0: t1 = 1: c1 = -1
     a$ = INPUT$(1, #1): b$ = INPUT$(1, #1): IF EOF(1) GOTO 2480
     IF a$ = CHR$(0) AND b$ = CHR$(0) THEN 2480
     x$ = INKEY$: IF x$ = "" THEN 1490
     IF x$ <> " " THEN 1440
     COLOR 4: PRINT " Press  <SPACE>  to Continue"
1410 x$ = INKEY$: IF x$ <> " " THEN 1410
     LOCATE CSRLIN - 1: PRINT "                           "
     LOCATE CSRLIN - 1: COLOR 1
     GOTO 1490
1440 IF x$ <> CHR$(3) THEN 1490
     COLOR 4: PRINT " Confirm Exit "
1460 x$ = INKEY$: IF x$ = "" THEN 1460
     IF x$ <> "y" THEN LOCATE CSRLIN - 1: PRINT "              ": LOCATE CSRLIN - 1: COLOR 1: GOTO 1490
     p$ = "": LOCATE CSRLIN - 1: GOTO 2480
1490 a$ = INPUT$(1, #1): b$ = INPUT$(1, #1): ' Program line No
     l& = ASC(a$) + ASC(b$) * 256
     IF l& < l1& GOTO 1940
     IF l& > l2& GOTO 2480
     f2 = 1: op$ = p$: p$ = STR$(l&) + " ": GOSUB 4270
     REM start text here
1550 a$ = INPUT$(1, #1): IF a$ = CHR$(0) GOTO 1360: ' end of line
     t = 0: a = ASC(a$): IF a$ = ":" AND q = 0 THEN da = 0
     IF a = 32 AND f$ = "," GOTO 1610
     IF da = 1 THEN 1610
     IF sf = 1 AND sb = 0 AND a = 33 AND q = 0 THEN sb = 1: GOTO 1550
     IF sb = 1 THEN a$ = kb$(a) + " ": sb = 0: GOTO 1860
1610 IF q = 0 OR (a AND 127) > 31 OR t7 = 0 GOTO 1680
     j = a: IF j > 128 THEN j = j - 96
     b$ = a$(j)
     IF b$ = b1$ THEN b = b + 1: GOTO 1550
     IF b > 0 THEN a$ = MID$(STR$(b + 1), 2) + f$ + b$: GOTO 1670
     a$ = f$ + b$
1670 b = 0: b1$ = b$: f$ = ",": f1 = 1: GOTO 1870
1680 IF a < 32 AND q = 0 THEN a$ = "???": GOTO 1860
     a = a - 128: IF a < 0 OR q <> 0 GOTO 1860
     IF a = 3 THEN da = 1
     IF a = 127 THEN a$ = p1$ + pi$ + p2$: GOTO 1860
     t = 1: a$ = k$(a)
     IF a < 42 THEN q1 = LEN(p$)
     IF a$ <> "#" AND a$ <> "&" GOTO 1850
     a$ = INPUT$(1, #1): IF a$ = CHR$(0) GOTO 1360
     tb = ASC(a$): IF a = 126 GOTO 1790
     IF tb < 2 OR tb > 10 THEN a$ = p1$ + "Token-4(" + MID$(STR$(tb), 2) + ")" + p2$: GOTO 1850
     a$ = k4$(tb): GOTO 1850
1790 IF tb < 2 THEN 1830
     IF tb < 39 THEN 1840
     IF tb < 48 THEN 1830
     IF tb < 91 THEN 1840
1830 a$ = p1$ + "Token-8(" + MID$(STR$(tb), 2) + ")" + p2$: GOTO 1850
1840 a$ = k8$(tb)
1850 IF a = 15 THEN q = 2
1860 GOSUB 2290
1870 IF a$ = qt$ AND q < 2 THEN q = 1 - q
     REM c=-1 for alphanumeric
     c = ASC(LEFT$(a$, 1)): c = (c < 48 OR c > 57) AND (c < 65 OR c > 90)
     IF t <> t1 OR t = 1 THEN t1 = t: IF NOT c AND NOT c1 THEN p$ = p$ + " ": GOSUB 2330
     c = ASC(RIGHT$(a$, 1)): c1 = ((c < 48 OR c > 57) AND (c < 65 OR c > 90)) OR a = 37

' This ain't right yet!

     IF LEN(a$) > 1 THEN
        p$ = p$ + a$
     ELSE
        p$ = p$ + PetConv$(a$)
     END IF
    
     GOSUB 2330
     GOTO 1550

1940 REM skip to next line
1950 a$ = INPUT$(1, #1): IF a$ = CHR$(0) THEN GOTO 1360
     GOTO 1950

2280 REM close off cursor expression
2290 IF f1 = 0 GOTO 2320
     IF b > 0 THEN p$ = p$ + MID$(STR$(b + 1), 2): GOSUB 2330
     b = 0: f1 = 0: b1$ = "": p$ = p$ + p2$: GOSUB 2330: f$ = p1$
2320 RETURN

2330 IF LEN(p$) < l9 GOTO 2470
     FOR j = l9 TO l9 * .6 STEP -1
     IF MID$(p$, j, 1) = ":" GOTO 2450
     NEXT j: FOR j = l9 - 1 TO l9 * .6 - 1 STEP -1
     p = ASC(MID$(p$, j))
     IF p = 91 OR p = 219 GOTO 2450
     IF p = 59 OR p = 44 OR p = 93 OR p = 221 THEN j = j + 1: GOTO 2450
     NEXT j: FOR j = l9 - 1 TO l9 * .6 - 1 STEP -1
     IF MID$(p$, j, 1) = "+" GOTO 2450
     IF MID$(p$, j, 1) = "-" GOTO 2450
     IF MID$(p$, j, 1) = " " GOTO 2450
     NEXT j: j = l9 - 1
2450 op$ = LEFT$(p$, j - 1): GOSUB 4270
     p$ = LEFT$("       ", LEN(STR$(l&)) + 1) + MID$(p$, j)
2470 RETURN

2480 IF LEN(p$) > 0 THEN f2 = 1: op$ = p$: GOSUB 4270
     IF f2 = 0 THEN COLOR 4: PRINT " ** no lines found **": COLOR 1
     CLOSE 1: GOSUB 2280: CLOSE 2
     END

2530
     IF ERR = 52 AND sf = 1 THEN PRINT : COLOR 4: PRINT "File "; qt$; g$; qt$; " does not exist": COLOR 1
     IF ERR = 53 AND sf = 1 THEN PRINT : COLOR 4: PRINT "File "; qt$; g$; qt$; " does not exist": COLOR 1
     IF ERR = 53 THEN rt = 2: RESUME NEXT
     IF ERR = 64 THEN rt = 3: RESUME NEXT
     COLOR 4: PRINT "   ***** DISK ERROR *****  - "; ERR: COLOR 1
     END

2650 PRINT RIGHT$("0000" + HEX$(sa), 4): RETURN
    
     REM identify machine used
2670 IF sa = 3 THEN ty$ = "700 or B-128": GOTO 2960
     IF a$ = CHR$(1) THEN 2720
     IF b$ = CHR$(4) AND a$ = CHR$(0) THEN x$ = INPUT$(1, #1): sa = sa + 1: IF x$ = CHR$(0) THEN 2720
     PRINT " Not a BASIC file !": rc = 1: RETURN
2710 IF b$ = CHR$(0) THEN ty$ = "700 or B-128": GOTO 2960
2720 IF b$ = CHR$(4) THEN ty$ = "PET/CBM": GOTO 2910
     IF b$ = CHR$(8) THEN ty$ = "C-64": GOSUB 2820: GOTO 2910
     IF b$ = CHR$(16) THEN ty$ = "Vic-5K or C-16/Plus 4": GOSUB 2820: GOTO 3320
     IF b$ = CHR$(18) THEN ty$ = "Expanded Vic": GOSUB 2820: GOTO 2910
     IF b$ = CHR$(28) THEN ty$ = "C-128": GOSUB 2820: GOTO 3380
     IF b$ = CHR$(64) THEN ty$ = "C-128": GOSUB 2820: GOTO 3380
     IF b$ = CHR$(112) THEN ty$ = "C-128 with BASIC 8": GOSUB 2820: GOTO 3540
     IF b$ = CHR$(128) THEN ty$ = "LOS-96": GOTO 3050
     ty$ = "[left15]is Unknown (try C-128)": GOSUB 2820: GOTO 3380: REM 128 ?
    
     REM control codes for colour machines
2820 a$(9) = "unlock": REM c-64
     a$(33) = "orange"
     a$(39) = "f5"
     a$(41) = "f2"
     a$(53) = "brown"
     a$(54) = "lt.red"
     a$(57) = "lt.green"
     RETURN
     REM extra tokens for normal machines
2910 FOR i = 91 TO 128
     k$(i) = p1$ + "token(" + MID$(STR$(128 + i), 2, 3) + ")" + p2$
     NEXT i
     RETURN
     REM 700 tokens
2960 k$(91) = "dclear": k$(92) = "bank": k$(93) = "bload": k$(94) = "bsave"
     k$(95) = "key": k$(96) = "delete": k$(97) = "else": k$(98) = "trap"
     k$(99) = "resume": k$(100) = "dispose": k$(101) = "pudef": k$(102) = "using"
     k$(103) = "err$": k$(104) = "instr"
     FOR i = 105 TO 128
     k$(i) = p1$ + "token(" + MID$(STR$(128 + i), 2, 3) + ")" + p2$
     NEXT i
     RETURN
     REM los-96 tokens
3050 k$(91) = "delete": k$(92) = "merge": k$(93) = "error": k$(94) = "resume"
     k$(95) = "dispose": k$(96) = "redim": k$(97) = "common": k$(98) = "out"
     k$(99) = "hard": k$(100) = "instr": k$(101) = "midstr": k$(102) = "using"
     k$(103) = "call": k$(104) = "rom": k$(105) = "else": k$(106) = "level"
     k$(107) = "func"
     FOR i = 108 TO 128
     k$(i) = p1$ + "token(" + MID$(STR$(128 + i), 2, 3) + ")" + p2$
     NEXT i
     RETURN
     REM plus-4, c-16 & c-128 tokens
3150 k$(76) = "rgr": k$(77) = "rclr": k$(78) = "rlum": k$(79) = "joy"
     k$(80) = "rdot": k$(81) = "dec": k$(82) = "hex$": k$(83) = "err$"
     k$(84) = "instr": k$(85) = "else": k$(86) = "resume": k$(87) = "trap"
     k$(88) = "tron": k$(89) = "troff": k$(90) = "sound": k$(91) = "vol"
     k$(92) = "auto": k$(93) = "pudef": k$(94) = "graphic": k$(95) = "paint"
     k$(96) = "char": k$(97) = "box": k$(98) = "circle": k$(99) = "gshape"
     k$(100) = "sshape": k$(101) = "draw": k$(102) = "locate": k$(103) = "color"
     k$(104) = "scnclr": k$(105) = "scale": k$(106) = "help": k$(107) = "do"
     k$(108) = "loop": k$(109) = "exit": k$(110) = "directory": k$(111) = "dsave"
     k$(112) = "dload": k$(113) = "header": k$(114) = "scratch": k$(115) = "collect"
     k$(116) = "copy": k$(117) = "rename": k$(118) = "backup": k$(119) = "delete"
     k$(120) = "renumber": k$(121) = "key": k$(122) = "monitor": k$(123) = "using"
     k$(124) = "until": k$(125) = "while": k$(126) = "#": k$(127) = "!!!"
     REM plus-4, c-16 & c-128 control codes
     a$(12) = "unlock": a$(15) = "flash.on": a$(47) = "flash.off"
     RETURN
     REM c-16 & plus 4 extra tokens (preceeded by $fe)
3320 GOSUB 3150
     k4$(2) = "pot": k4$(3) = "bump": k4$(4) = "pen": k4$(5) = "rsppos"
     k4$(6) = "rsprite": k4$(7) = "rspcolor": k4$(8) = "xor": k4$(9) = "rwindow"
     k4$(10) = "pointer"
     RETURN
     REM c-128 extra tokens (preceeded by $fe)
3380 GOSUB 3320: REM includes plus 4 extras as well (but preceeded by $ce)
     k8$(2) = "bank": k8$(3) = "filter": k8$(4) = "play": k8$(5) = "tempo"
     k8$(6) = "movspr": k8$(7) = "sprite": k8$(8) = "sprcolor": k8$(9) = "rreg"
     k8$(10) = "envelope": k8$(11) = "sleep": k8$(12) = "catalog": k8$(13) = "dopen"
     k8$(14) = "append": k8$(15) = "dclose": k8$(16) = "bsave": k8$(17) = "bload"
     k8$(18) = "record": k8$(19) = "concat": k8$(20) = "dverify": k8$(21) = "dclear"
     k8$(22) = "sprsav": k8$(23) = "collision": k8$(24) = "begin": k8$(25) = "bend"
     k8$(26) = "window": k8$(27) = "boot": k8$(28) = "width": k8$(29) = "sprdef"
     k8$(30) = "quit": k8$(31) = "stash": k8$(32) = "!!": k8$(33) = "fetch"
     k8$(34) = "!!!": k8$(35) = "swap": k8$(36) = "off": k8$(37) = "fast"
     k8$(38) = "slow"
     k$(78) = "&"
     REM c-128 special control codes
     a$(9) = "tab": a$(33) = "dark.purple": a$(55) = "dark.cyan": a$(63) = "light.cyan"
     RETURN
     REM basic 8 tokens (also preceeded by $fe)
3540 GOSUB 3380: REM assume c-128 machine
     k8$(48) = "grow": k8$(49) = "arc": k8$(50) = "line": k8$(51) = "drwmoda"
     k8$(52) = "pattern": k8$(53) = "buffer": k8$(54) = "struct": k8$(55) = "sdat"
     k8$(56) = "text": k8$(57) = "scroll": k8$(58) = "walrus": k8$(59) = "font"
     k8$(60) = "scrdef": k8$(61) = "pixel": k8$(62) = "mouse": k8$(63) = "dot"
     k8$(64) = "send": k8$(65) = "hcopy": k8$(66) = "logo": k8$(67) = "cbrush"
     k8$(68) = "angle": k8$(69) = "scale": k8$(70) = "origin": k8$(71) = "view"
     k8$(72) = "drwmodb": k8$(73) = "store": k8$(74) = "display": k8$(75) = "screen"
     k8$(76) = "clear": k8$(77) = "mode": k8$(78) = "brushpatrn": k8$(79) = "sphere"
     k8$(80) = "cylinder": k8$(81) = "toroid": k8$(82) = "spool": k8$(83) = "dir$"
     k8$(84) = "sclip": k8$(85) = "style": k8$(86) = "lstruct": k8$(87) = "sstruct"
     k8$(88) = "ptr": k8$(89) = "flash": k8$(90) = "zoom"
     a$(3) = "set colour": REM special basic 8 control code
     a$(33) = "light.purple": a$(55) = "light.cyan": a$(63) = "dark.cyan"
     RETURN
     REM superbase tokens (preceeded by $21 "!")
3700 GOSUB 3380: REM assume c-128 machine
     DATA "ENTER","SELECT","FIND","OUTPUT","CALC","REPORT","EXECUTE","HELP"
     DATA "SYS","FILE","FORMAT","BATCH","SORT","PROG","MAINTAIN","MEMO"
     DATA "HELP","MENU","EXPORT","IMPORT","DISPLAY","CATALOG","PRINT","DIRECTORY"
     DATA "ACROSS","DOWN","DS","RECORD","FROM","ALL","THE","CLEAR"
     DATA "STORE","DEBUG","BRKON","BRKOFF","RESTART","WHERE","SCREEN","RUN"
     DATA "OLD","WAIT","CLR","NEW","ENDREPORT","STOP","LIST","PDEV"
     DATA "RMARG","PLEN","TLEN","CONT","LMARG","LFEED","PDEF","SPACE"
     DATA "IF","ASK","SETLINK","LINK","ELINK","RLINK","TITLE","SUBTOTAL"
     DATA "TOTAL","DETAIL","PLUS","END","NMAT","PMAT","EOF","EOL"
     DATA "QUIT","LOAD","SAVE","FILL","DATABASE","PROTECT","DUMP","SET"
     DATA "PERFORM","DATE","CONVERT","CHECK","SUPERSCRIPT","MODE","STATUS","CLOSE"
     DATA "COLS","COUNT","VARSPACE","OPEN","CHAIN"
     FOR i = 1 TO 93: READ kb$(i): NEXT i
     FOR j = 94 TO 127
     kb$(j) = p1$ + "TOKEN(" + MID$(STR$(j), 2, 3) + ")" + p2$
     NEXT j
     RETURN
     REM set up for required printer
3890 INPUT "[down]Printer Type [rvs]e[rvs.off]pson, [rvs]c[rvs.off]bm  or [rvs]a[rvs.off]scii  e[left3]"; pt$
     IF pt$ = "e" THEN ch = 5: GOTO 3960
     IF pt$ = "a" THEN ch = 5: ps = 0: ex$ = "": eq$ = "": RETURN
     IF pt$ <> "c" THEN PRINT "[up3]": GOTO 3890
     ps = 8
     ex$ = CHR$(14): eq$ = CHR$(20): p1$ = CHR$(219): p2$ = CHR$(221)
     RETURN
3960 'OPEN ch, 4, 5: PRINT #ch, CHR$(27); "@"
     PRINT "[down]Epson Printer on Serial Port, Auto Line Feed"
3980 INPUT "[down]Text Style - [rvs]p[rvs.off]ica, [rvs]e[rvs.off]lite or [rvs]c[rvs.off]ondensed  e[left3]"; tp$
     IF tp$ = "e" THEN PRINT #ch, CHR$(27); "M"; : pc = 90: GOTO 4020
     IF tp$ = "c" THEN PRINT #ch, CHR$(15); : pc = 125: GOTO 4020
     IF tp$ <> "p" THEN PRINT "[up3]": GOTO 3980
4020 PRINT #ch, CHR$(27); "N"; CHR$(3); : CLOSE 2
     ex$ = CHR$(14): eq$ = CHR$(20): ps = 5
     RETURN
4050 REM override machine type
     PRINT "[down]Specify Machine Type[down]"
     PRINT "1 - PET/CBM"
     PRINT "2 - LOS-96"
     PRINT "3 - 700 or B-128"
     PRINT "4 - Vic-20"
     PRINT "5 - C-64"
     PRINT "6 - C-16/Plus 4"
     PRINT "7 - C-128"
     PRINT "8 - C-128 with BASIC 8"
4150 INPUT "Select a type   1[left3]"; x
     IF x < 1 OR x > 8 THEN PRINT "[up2]": GOTO 4150
     IF x = 3 THEN b$ = CHR$(0)
     IF x = 1 THEN b$ = CHR$(4)
     IF x = 5 THEN b$ = CHR$(8)
     IF x = 6 THEN b$ = CHR$(16)
     IF x = 4 THEN b$ = CHR$(18)
     IF x = 7 THEN b$ = CHR$(28)
     IF x = 8 THEN b$ = CHR$(112)
     IF x = 2 THEN b$ = CHR$(128)
     RETURN
     REM deal with conversion to ascii
4270 ' if ch=5 then sys 2816:rem convert to ascii
     PRINT #2, op$
     PRINT op$
     RETURN

'  Function PETConv$
'
' Converts PETSCII to ASCII
'
FUNCTION PetConv$ (in$)
    out$ = t$(ASC(in$))
    PetConv$ = out$
END FUNCTION

