,$*
* HIS PROGRAM COMBINES THE SCROLLTEXT
* DEMO RUNNING IN AN INTERRUPT WITH
* A OBIN-INSPIRED BLOCK SPRITE
* CONTROLLABLE BY THE JOYSTICK.  T
* DEMONSTRATES INTERRUPT PROGRAMMING
* AS WELL AS SIMPLE SPRITE COMMANDS.
*
* TEPHEN . UDD
* 10/30/04
*

BYTE JOYCOUNT=7      ;COUNTER
BYTE JOY2@$DC00,TEMP
BYTE SPRITE(63)@832
UINT XPOS=100
UBYTE YPOS=100

BYTE MESG(80),MESGLEN
BYTE ROW1(40)@$0400  ;FIRST SCREEN ROW

MESG$ = !S" OBIN ARBRON RULES!!! "
MESGLEN = 23
CROLL2_ROWPOS = 39   ;INITIAL SCREEN POSITION

;
; NIT SCROLL 
;
ISABLEIMER      ;SHUT DOWN  TIMER  (KERNAL )
ETASTER(50)
ETOUTINE(CROLL1)
ETOL38              ;USE 38 COLS TO MAKE IT SMOOTH
NABLEASTER

;
; ET UP SPRITE
;
SEPRITETUFF

BYTE X
FOR X=0:62
  SPRITE(X)=255
NEXT

ETPRITETR(0,13)
PRITEN(0)

REPEAT
  WAIT $D012,255
  ETPRITE(0,XPOS)
  ETPRITE(0,YPOS)
  WAIT JOYCOUNT,0     ;AIT FOR  SIGNAL
  JOYCOUNT = 1
  TEMP = JOY2 BITEOR 255
  TESTALL
    CASE TEMP BITAND 1     ;UP
      YPOS = YPOS-1
    CASE TEMP BITAND 2     ;DOWN
      YPOS = YPOS+1
    CASE TEMP BITAND 4     ;LEFT
      XPOS = XPOS-1
    CASE TEMP BITAND 8     ;RIGHT
      XPOS = XPOS+1
    CASE TEMP BITAND 16    ;FIRE
      INC $D027       ;SPRITE COLOR
  ENDTEST
FOREVER

;-------------------------------
;
;  ROUTINES
;
; HE FIRST  ROUTINE FINE-SCROLLS
; THE SCREEN AND SETS UP THE NEXT .
;
;-------------------------------

IRQ CROLL1()
  BYTE COUNT

  CKASTER        ;ACKNOWLEDGE IRQ
  ETCROLL(COUNT)   ;FINE SCROLL
  ETASTER(59)       ;SET NEXT 
  ETOUTINE(CROLL2)

  COUNT=COUNT-1
  IF COUNT<0
    CROLL2_FLAG = 1
    COUNT = 7
  ELSE
    CROLL2_FLAG = 0
  ENDIF
ENDIRQ

;
; HE SECOND  ROUTINE UPDATES THE
; MESSAGE TEXT AS NEEDED.  Y UPDATING
; THE TEXT AFTER THE SCREEN HAS BEEN
; UPDATED THE SCROLLING IS SMOOTH.
;

IRQ CROLL2()_BYTE FLAG, BYTE ROWPOS
  BYTE OFFSET=0,ENDTEXT

  CKASTER        ;ACKNOWLEDGE IRQ
  ETCROLL(7)       ;IX REST OF SCREEN
  ETASTER(50)
  ETOUTINE(CROLL1)

  IF FLAG=1
    ENDTEXT = OFFSET+39
    IF ENDTEXT > MESGLEN
      ENDTEXT = MESGLEN
    ENDIF

    ROW1$(ROWPOS:39) = MESG$(OFFSET:ENDTEXT)
    IF ROWPOS>0
      ROWPOS = ROWPOS-1 ;MOVE MESG LEFT
    ELSIF OFFSET < MESGLEN
      OFFSET = OFFSET+1 ;IF ALL THE WAY LEFT THEN MOVE THROUGH MESSAGE
    ELSE
      ROWPOS = 39       ;RESET IF DONE
      OFFSET = 0
    ENDIF
  ENDIF

  IF JOYCOUNT > 0     ;ECREASE THE JOYSTICK COUNTER
    JOYCOUNT = JOYCOUNT-1
  ENDIF

MPERNAL

