%
% Map maker -- construct a map for the MANTA arena.  Define the map
% as an array, then process the array into a C64 file that can be
% read in.
%
% SLJ 2/22/2024
%
clear all;

map = {
'1111111111111111111111111111111111111111111111111111111111111111'
'1   44RED.ROOM4l444444l4A444MAZE444ING444444445555             1'
'1   4                                        45  e 5555555555551'
'1   4                                        45 55 5          f1'
'1   4                  4444c44444d44444l4444 45 5  5 55555555 51'
'1   4                  c                   4 r5 55i5 55555555 51'
'1   4          w       4                   4               e5 51'
'1   4                  d                   5555555 5i55555555 51'
'1   4                  4                         5 5        5 51'
'1   3   v44c444d444c4444     5e5               555 5        5 51'
'1   3   3                    5 5555i55555555   e   5        5 51'
'1   3   3                    5             5   55555        5 51'
'1   3   3                    555555 555555 5                5 51'
'1   3   3                         5 5    5 5555i5555i5555i555 51'
'1   3   3                         i i    5                    51'
'1   3   3                         5 5    5 5555i5555 5555i555f51'
'1   3   3                         5 5    5 5       5 5         1'
'1   3   3                         5 5    5 5       5 5         1'
'1   3   3                         5 5    5 5       5 5         1'
'1   3   3                         5 5    5 5       5 5         1'
'1b333   33333333WOO.WOO.WOO333    5 5    5 5 5e5   5 5555555   1'
'1b                           3    i i    5 555 5   5       5   1'
'1b                           3    5 5    5     5   5555555 5   1'
'1b    b                      3    5 5    5555555         5e5   1'
'1b                           3    5 5            55555555555   1'
'1b33333333333333333333333x   2    5 55555        5         5   1'
'1                        2   2    5     f        5 5555555 5   1'
'1                        2   2    55555 55555i5555 5     5 5   1'
'1                        G   2        5            5     5 5   1'
'1                        N   2        5555555 555555     5 555 1'
'1                        I   2              5 5          i   e 1'
'1                        O   2              5 5          5 555 1'
'1                        G   2              5 5          5 5   1'
'1                        .   2              5 5          5 5   1'
'1                        P   2              5 5     555555 5   1'
'1                        E   2              5 5     5      i   1'
'1                        E   2     55555    5 5     5  555 555 1'
'1                        K   2     e   5    5 5     5   f5   5 1'
'1                        2   2     555 5    5 5     555 5555 5 1'
'1                        2   2       5 555555 5       5  5e  5 1'
'122222222a22222222       2   2       5        5       55 55555 1'
'1a               2222a2222   2       5555555555        5    f  1'
'1a                           2         111JASON111     5555 5  1'
'1a       a                   2         1         R       55 5  1'
'1a                           2         k         O       5  5  1'
'1a               2222a22222222         1         B       5 55  1'
'1222222s   s222222111CORALp1NICHOLASq111         I       5  5  1'
'1      1   1      1                              N       55 5  1'
'1      E   R      j                       1NEKKOD1       5  5  1'
'1      U   O      A                       16666LAST.ROOM65 55  1'
'1      L   O      R                       1g               5   1'
'1      B   M      U                       16   66666666665f5   1'
'1      1   1      A                       1h   hhhhhhhhhhh     1'
'1      i   i      L                       1h             h     1'
'1      1   1      1oNMUTUAnELLEONmYBBA11  1h     hhh     h     1'
'1      1   1                           1  1h     hhh     h     1'
'1eENTERy   zHEREe1111111111111111GREETZ!  1h     hhh     h     1'
'Y                                         Wh     hhh     u222221'
'Z                                         Yh                  21'
'A                                         Nhhhhhh2222222222   21'
'R                                         11?22222222222222   21'
'C                                                             21'
'1                                                             21'
'111111111i1111111111111111111111111111111111ZELUR.UPCREPUS2k2221'
};

%
% Table of maze values and textures
%
% Texture list:
%
% 1 white brick
% 2 blue stone
% 3 gray stone
% 4 red brick 1
% 5 red brick 2
% 6 black brick
%
% 16 blues80x
% 17 stooges
% 18 marilyn
% 19 face80x
% 20 angry smile
% 21 red smile
% 22 joker1
% 23 joker2
% 24 eagle80x
% 25 redhead
% 26 C= logo
% 27 girl1
% 28 left arrow
% 29 right arrow
% 30 painter
% 31 viola
% 32 ballet
% 33 hockey
% 34 dino
%
% 48-53 crazy1-crazy6
%
% Alphabet: 64-89
%  A - 64
%  B - 65
%  etc.
%
% 90 solid red (space)
%
% 127 animated texture

% symbol value X-texture Y-texture
mazeval = {
 '1', 1, 1, 1
 '2', 2, 2, 2
 '3', 3, 3, 3
 '4', 4, 4, 4
 '5', 5, 5, 5
 '6', 6, 6, 6
 '7', 7, 1,24
 'a',16,16,16
 'b',17,17,17
 'c',18,18,18
 'd',19,19,19
 'e',20,20,20
 'f',21,21,21
 'g',22,22,22
 'h',23,23,23
 'i',24,24,24
 'j',25,25,25
 'k',26,26,26
 'l',27,27,27
 'm',30,30,30
 'n',31,31,31
 'o',32,32,32
 'p',33,33,33
 'q',34,34,34
 'r',48, 4, 5
 's',49, 1, 2
 't',50, 1, 2
 'u',51,23, 2
 'v',52, 3, 4
 'w',53,19,18
 'x',54, 2, 3
 'y',55,21,29
 'z',56,21,28
 '!',57, 1,29
 'A',64,64,64
 'B',65,65,65
 'C',66,66,66
 'D',67,67,67
 'E',68,68,68
 'F',69,69,69
 'G',70,70,70
 'H',71,71,71
 'I',72,72,72
 'J',73,73,73
 'K',74,74,74
 'L',75,75,75
 'M',76,76,76
 'N',77,77,77
 'O',78,78,78
 'P',79,79,79
 'Q',80,80,80
 'R',81,81,81
 'S',82,82,82
 'T',83,83,83
 'U',84,84,84
 'V',85,85,85
 'W',86,86,86
 'X',87,87,87
 'Y',88,88,88
 'Z',89,89,89
  '.',90,90,90
 '?',127,48,48 % animated texture
 };

 %
 % Now go through the map, starting from the bottom left, and create the
 % data arrays (map and table).
 %
 mapc000 = zeros(64,64);
 xmaptex = zeros(128);
 ymaptex = zeros(128);

 for y=0:63
   mapy = 64-y;
   for x=0:63
     mapx = x+1;
     sym = map{mapy}(mapx);
     sval = 0;
     for k=1:length(mazeval)
       if sym == mazeval{k,1}
         sval = mazeval{k,2};
         mapc000(y+1,x+1) = sval;
         xmaptex(sval+1) = mazeval{k,3};
         ymaptex(sval+1) = mazeval{k,4};
       endif
     endfor
   endfor
 endfor

%
% Output the files in C64 format
%

bitname = ["arena1.map"];
fid = fopen(bitname,"w");
fwrite(fid,0); % Put in a load address of $c000
fwrite(fid,192);
for y=1:64
  for x=1:64
    fwrite(fid,mapc000(y,x));
  endfor
endfor
fclose(fid);

fid = fopen("arena1.key","w");
fwrite(fid,0); % Put in a load address of $5000
fwrite(fid,80);
for x=1:128
  fwrite(fid,xmaptex(x));
endfor
for x=1:128
  fwrite(fid,ymaptex(x));
endfor
fclose(fid);



