c64fILE
crazy.l.s








{SHIFT-+}
*
* A "16-bit" version, where the
* raycaster calculations are done
* in 16 bits rather than 8 bits,
* to improve some resolution and
* distance issues seen in the 8 bit
* version.
*
* SLJ 1/3/2024
*

********************************
*
* Arena -- a simple code to wander
* through a map, using the racasting
* libraries.
*
* SLJ 12/30/2023
*
********************************

********************************
*
* Arena
*
* An attempt at making a 3D raycasting
* engine. This code implements the
* routines from
* http://lodev.org/cgtutor/raycasting.html
*
* S Judd
* 11/2/2023
* (One more for old time's sake...)
*
********************************


black equ 0
white equ 1
red equ 2
cyan equ 3
purple equ 4
green equ 5
blue equ 6
yellow equ 7
orange equ 8
brown equ 9
ltred equ 10
gray1 equ 11
gray2 equ 12
ltgreen equ 13
ltblue equ 14
gray3 equ 15

xmaptex equ $5000     ;map textures, x-direction
ymaptex equ $5080     ;map textures, y-direction
lo160 equ $5100       ;x*160 lo
hi160 equ $5200       ;x*160 hi
xtextab equ $5300     ;table of 80*x/256
invtablo equ $5400    ;65536/x
invtabhi equ $5500    ;
multlo1 equ $5600     ;f(a-b) 256 bytes
multlo2 equ $5700     ;f(a+b) 512 bytes
multhi1 equ $5900     ;high bytes same
multhi2 equ $5a00
invzlo equ $5c00      ;d/z, for GetHeight
invzhi equ $5d00
mapylo equ $5e00      ;low and high address
mapyhi equ $5e80      ;of map coords
sintablo equ $5f00    ;sin(x),cos(x)
costablo equ sintablo+16
sintabhi equ $5f80
costabhi equ sintabhi+16

sub asm InitGfx@$3000()
sub asm AddTexture@$3003(@a)
sub asm InitBitmaps@$3006( &
      byte color0@$f9, byte color1@$fa, &
      byte color2@$fb, byte color3@$fc &
      )
sub asm ClearBitmap@$3009(@a)
sub asm SetVICBuffer@$300c(@a)
sub asm DrawCamera@$300f(ubyte theta@$f7, int x0@$f8, int y0@$fa, ubyte buf@$fc)


;
; basic header
;
*         do  0
 org $0801 ;set assemble address

 da $080b ;link
         da  2024     ;line number
 dfb $9e ;sys
 txt '2061'
 dfb 00,00,00
*         fin
;
;
; Test code
;
;

  byte key
  int dirx,diry      ; Ray direction dy/dx
  int temp@$f7
  int temp1,temp2
  int xpos, ypos
  byte theta
  ubyte buffer
  uint height
  ubyte x1,x,tx
  uint zp@$fb
  ubyte ztemp@$fb

  ubyte tempa,tempx,tempy

  println "crazy - wyndex 2/2024"
  println "use joystick in port 2"

  LoadTables()
  InitMap()
  LoadGfx()
  InitGfx()

  buffer = 1
; do 0
  InitBitmaps(black, red, blue, gray3)
  ClearBitmap(buffer)
  SetVICBuffer(buffer)
; fin

  jsr DisableInterrupt


;  Test1(buffer)

  xpos=512            ;320
  ypos=1011           ;1018
  theta=16

  repeat

    Animate()
    buffer = buffer eor 1
    OptimizeSCPU(buffer)
    DrawCamera(theta,xpos,ypos,buffer)
    SetVICBuffer(buffer)

;    lda xpos+1
;    sta temp1
;    lda ypos+1
;    sta temp2

    ldx theta
    lda costablo,x    ;64*cos(theta)
    sta dirx
    lda costabhi,x
    sta dirx+1
    lda sintablo,x
    sta diry
    lda sintabhi,x
    sta diry+1

;    println "theta="theta " xpos="xpos " ypos="ypos
;    println "  dirx="dirx " diry="diry

    jsr ReadJoy

  forever
endsub

;
; Read joystick port 2
;
ReadJoy
         lda $dc00
         and #1
         bne :dn
         jsr movefwd
:dn
         lda $dc00
         and #2
         bne :lf
         jsr moveback
:lf
         lda $dc00
         and #4
         bne :rt
         jsr turnleft
:rt
         lda $dc00
         and #8
         bne :rts
         jsr turnright
:rts     rts

*
* Routines to move/turn
*
* We move in steps of dirx/256
*

movefwd
      ldx #00         ;high byte
      lda dirx+1      ;integer part
      bpl :c1
      dex
:c1
      clc
      adc xpos
      sta temp1
      txa
      adc xpos+1
      sta temp1+1

      ldx #00         ;high byte
      lda diry+1 ;int
      bpl :c2
      dex
:c2
      clc
      adc ypos
      sta temp2
      txa
      adc ypos+1
      sta temp2+1

; check map coord, exit if hit a wall

         ldx temp2+1
         ldy temp1+1
         lda mapylo,x ;we could optimize
         sta zp       ;but this is cleaner
         lda mapyhi,x
         sta zp+1

;   jsr :debug

         lda (zp),y   ;map x/y
         bne :rts     ;exit if we hit an occupied square

         lda temp1    ;otherwise copy new location
         sta xpos
         lda temp1+1
         sta xpos+1
         lda temp2
         sta ypos
         lda temp2+1
         sta ypos+1

:rts     rts

 do 0
:debug
         sta tempa
         stx tempx
         sty tempy

 println "theta=",theta," xpos=",xpos," ypos=",ypos
 println " dirx=",dirx," diry=",diry
 println " temp1=",temp1," temp2=",temp2," zp=",zp
 println " .a=",tempa," .x=",tempx," .y=",tempy

         ldx tempx
         ldy tempy
         lda tempa
         rts

:a dfb 00
:x dfb 00
:y dfb 00
 fin

moveback
         ldx #00
         lda dirx+1
         bpl :c1
         dex
:c1
         sta temp1
         stx temp1+1

         lda xpos
         sec
         sbc temp1
         sta temp1
         lda xpos+1
         sbc temp1+1
         sta temp1+1

         ldx #00
         lda diry+1
         bpl :c2
         dex
:c2
         sta temp2
         stx temp2+1

         lda ypos
         sec
         sbc temp2
         sta temp2
         lda ypos+1
         sbc temp2+1
         sta temp2+1

; check map coord, exit if hit a wall

         ldx temp2+1
         ldy temp1+1
         lda mapylo,x ;we could optimize
         sta zp       ;but this is cleaner
         lda mapyhi,x
         sta zp+1
         lda (zp),y ;map x/y
         bne :rts     ;exit if we hit an occupied square

         lda temp1    ;otherwise copy new location
         sta xpos
         lda temp1+1
         sta xpos+1
         lda temp2
         sta ypos
         lda temp2+1
         sta ypos+1

:rts     rts

turnright
      ldx theta
      dex
      txa
      and #63
      sta theta
      rts

turnleft
      ldx theta
      inx
      txa
      and #63
      sta theta
      rts


;
; Interrupt routines
;

DisableInterrupt
         sei
         lda #$7f
         sta $dc0d    ;Disable timers
         sta $dd0d
         lda $dc0d    ;clear timers
         lda $dd0d

         lda #<:irq ;just in case...
         sta $0314
         lda #>:irq
         sta $0315

         cli
         rts

:irq     pla
         tay
         pla
         tax
         pla

         rti

;
; Animate a texture
;
sub Animate()

  byte idx=0

         ldx #127      ;texture number
         lda idx
         inc
         cmp #6
         bcc :c1
         lda #0
:c1      sta idx
         clc
         adc #48 ;textures 48-53
         sta xmaptex,x ;update tables
         sta ymaptex,x
         rts

*
* Initialize map
*
* The 64x64 map is stored in
* $c000-$cfff.
*
* The map is arranged in row,column
* format, with y-coords stored in
* maplo and maphi.
*
* y=0 x=0..63 $c000-$c03f
* y=1 x=0..63 $c040-$c07f
* ...
* y=63 x=0..63 $cfc0-cfff
*

sub InitMap()
  ubyte dev@$ba

  load "arena1.map",dev,$c000 ;map
  load "arena1.key",dev,$5000 ;symbol-texture map

         rts

 do 0
*-------------------------------
;
; Test map
;

  fillmem($c000,$cfff,00)

;
; Add a boundary around the edges
;


         ldy #00      ;x-coord
:l1
         ldx #00 ;y-coord
         lda #1  ;set edges to 1
         jsr setmap
         ldx #63
         lda #1  ;set edges to 1
         jsr setmap
         iny
         cpy #64
         bne :l1

         ldx #1
:l2
         ldy #00 ;x-coord
         lda #1  ;set edges to 1
         jsr setmap
         ldy #63
         lda #1  ;set edges to 1
         jsr setmap
         inx
         cpx #63
         bne :l2

; Now put a few blocks in for testing

         lda #2
         ldy #3       ;x
         ldx #2       ;y
         jsr setmap
         lda #2
         ldy #4
         ldx #2
         jsr setmap
         lda #2
         ldy #5
         ldx #2
         jsr setmap

         lda #3
         ldy #3
         ldx #3
         jsr setmap
         lda #3
         ldy #3
         ldx #4
         jsr setmap

         rts

setmap
         pha
         lda mapylo,x
         sta zp
         lda mapyhi,x
         sta zp+1
         pla
         sta (zp),y
         rts
*-------------------------------
 fin

*
* Load pre-computed tables from files
*
sub LoadTables()
  byte dev@$ba

  load"tables5100-5fff",dev,$5100
endsub

*
* Load library and textures
*
sub LoadGfx()
  byte dev@$ba

  load"raycast3.o",dev,$3000

  CountTex(1)
  load "redbrick.bitmap",dev,$8000
  AddTexture(1)
  CountTex(2)
  load "blueston.bitmap",dev,$8000
  AddTexture(2)
  CountTex(3)
  load "greyston.bitmap",dev,$8000
;  load "whiteb18.bitmap",dev,$8000
  AddTexture(3)
  CountTex(4)
  load "brick280.bitmap",dev,$8000
  AddTexture(4)
  CountTex(5)
  load "redbrick.bitmap",dev,$8000
  AddTexture(5)
  CountTex(6)
  load "blackb80.bitmap",dev,$8000
  AddTexture(6)
;  load "purplest.bitmap",dev,$8000
;  AddTexture(7)

  CountTex(7)
  load "blues80x.bitmap",dev,$8000
  AddTexture(16)
  CountTex(8)
  load "stooges3.bitmap",dev,$8000
  AddTexture(17)
  CountTex(9)
  load "marilyn8.bitmap",dev,$8000
  AddTexture(18)
  CountTex(10)
  load "face80x1.bitmap",dev,$8000
  AddTexture(19)
  CountTex(11)
  load "angrysmi.bitmap",dev,$8000
  AddTexture(20)
  CountTex(12)
  load "redsmile.bitmap",dev,$8000
  AddTexture(21)
  CountTex(13)
  load "joker1.bitmap",dev,$8000
  AddTexture(22)
  CountTex(14)
  load "joker2.bitmap",dev,$8000
  AddTexture(23)
  CountTex(15)
  load "eagle80x.bitmap",dev,$8000
  AddTexture(24)
  CountTex(16)
  load "red80x16.bitmap",dev,$8000
  AddTexture(25)
  CountTex(17)
  load "commodor.bitmap",dev,$8000
  AddTexture(26)
  CountTex(18)
  load "girl180x.bitmap",dev,$8000
  AddTexture(27)
  CountTex(19)
  load "left80x1.bitmap",dev,$8000
  AddTexture(28)
  CountTex(20)
  load "right80x.bitmap",dev,$8000
  AddTexture(29)
  CountTex(21)
  load "painter8.bitmap",dev,$8000
  AddTexture(30)
  CountTex(22)
  load "viola180.bitmap",dev,$8000
  AddTexture(31)
  CountTex(23)
  load "ballet18.bitmap",dev,$8000
  AddTexture(32)
  CountTex(24)
  load "hockey18.bitmap",dev,$8000
  AddTexture(33)
  CountTex(25)
  load "dino180x.bitmap",dev,$8000
  AddTexture(34)

  CountTex(26)
  load "crazy1.bmap",dev,$8000
  AddTexture(48)
  CountTex(27)
  load "crazy2.bmap",dev,$8000
  AddTexture(49)
  CountTex(28)
  load "crazy3.bmap",dev,$8000
  AddTexture(50)
  CountTex(29)
  load "crazy4.bmap",dev,$8000
  AddTexture(51)
  CountTex(30)
  load "crazy5.bmap",dev,$8000
  AddTexture(52)
  CountTex(31)
  load "crazy6.bmap",dev,$8000
  AddTexture(53)

  CountTex(32)
  load "A80.bmap",dev,$8000
  AddTexture(64)
  CountTex(33)
  load "B80.bmap",dev,$8000
  AddTexture(65)
  CountTex(34)
  load "C80.bmap",dev,$8000
  AddTexture(66)
  CountTex(35)
  load "D80.bmap",dev,$8000
  AddTexture(67)
  CountTex(36)
  load "E80.bmap",dev,$8000
  AddTexture(68)
  CountTex(37)
  load "F80.bmap",dev,$8000
  AddTexture(69)
  CountTex(38)
  load "G80.bmap",dev,$8000
  AddTexture(70)
  CountTex(39)
  load "H80.bmap",dev,$8000
  AddTexture(71)
  CountTex(40)
  load "I80.bmap",dev,$8000
  AddTexture(72)
  CountTex(41)
  load "J80.bmap",dev,$8000
  AddTexture(73)
  CountTex(42)
  load "K80.bmap",dev,$8000
  AddTexture(74)
  CountTex(43)
  load "L80.bmap",dev,$8000
  AddTexture(75)
  CountTex(44)
  load "M80.bmap",dev,$8000
  AddTexture(76)
  CountTex(45)
  load "N80.bmap",dev,$8000
  AddTexture(77)
  CountTex(46)
  load "O80.bmap",dev,$8000
  AddTexture(78)
  CountTex(47)
  load "P80.bmap",dev,$8000
  AddTexture(79)
  CountTex(48)
  load "Q80.bmap",dev,$8000
  AddTexture(80)
  CountTex(49)
  load "R80.bmap",dev,$8000
  AddTexture(81)
  CountTex(50)
  load "S80.bmap",dev,$8000
  AddTexture(82)
  CountTex(51)
  load "T80.bmap",dev,$8000
  AddTexture(83)
  CountTex(52)
  load "U80.bmap",dev,$8000
  AddTexture(84)
  CountTex(53)
  load "V80.bmap",dev,$8000
  AddTexture(85)
  CountTex(54)
  load "W80.bmap",dev,$8000
  AddTexture(86)
  CountTex(55)
  load "X80.bmap",dev,$8000
  AddTexture(87)
  CountTex(56)
  load "Y80.bmap",dev,$8000
  AddTexture(88)
  CountTex(57)
  load "Z80.bmap",dev,$8000
  AddTexture(89)

  CountTex(58)
  load "red.bmap",dev,$8000
  AddTexture(90)
endsub

sub CountTex(ubyte idx)
  println "loading ",idx,"/58"
endsub

*
* Optimize SCPU for VIC buffer
*
* Should work with v1 and v2 SCPUs
*
sub OptimizeSCPU(@a)
         cmp #00
         bne ob1
         sta $d07e    ;enable registers
         sta $d075 ;vic bank 1
         sta $d07f  ;regs out
         rts
ob1      sta $d07e
         sta $d074 ;vic bank 2
         sta $d07f
         rts



          put "putcore.i.s"


