c64fILE
init3.e.s











*
* Initialization modified for
* 16-bit version.  The exp and log
* tabs are removed, and replaced with
* a 16-bit version of 1/x
*
* SLJ 1/3/2024
*

********************************
*
* Initialization routines for Arena
*
* sub ent InitTables()
* sub ent InitMap()
* sub ent InitVLine()
*
* SLJ 12/30/23
*
********************************

;          rel

*
* Several tables are needed:
*   128 bytes map column address
*   256 bytes sin(x) (cos(x)=sin(x+16)
*   256 bytes 256/x
*   256 bytes log(x)
*   256 bytes e^x
*

lo160 equ $5100       ;x*160 lo
hi160 equ $5200       ;x*160 hi
xtextab equ $5300     ;table of 80*x/256
invtablo equ $5400    ;65536/x
invtabhi equ $5500    ;
multlo1 equ $5600     ;f(a-b) 256 bytes
multlo2 equ $5700     ;f(a+b) 512 bytes
multhi1 equ $5900     ;high bytes same
multhi2 equ $5a00
invzlo equ $5c00      ;d/z, for GetHeight
invzhi equ $5d00
mapylo equ $5e00      ;low and high address
mapyhi equ $5e80      ;of map coords
sintablo equ $5f00    ;sin(x),cos(x)
costablo equ sintablo+16
sintabhi equ $5f80
costabhi equ sintabhi+16

* Two buffers are used at $6000 and
* at $A000.  The memory map is
*
*   $4000-$4C00 Available sprites etc
*   $4C00-$4FFF Color map
*   $5000-$5FFF tables
*   $6000-$7FFF Bitmap (buffer 0)
*   $8000-$8C00 Available sprites
*   $8C00-$8FFF Color map
*   $9000-$9FFF Graphics tables
*   $A000-$BFFF Bitmap (buffer 1)


zp equ $02

;
; There is a bug in slang with
; floating point operations not
; working with REL files, so for
; now we are just splitting this all
; out.
;
; SLJ 1/1/2024
;

 InitTables()
 InitVline()
 brk

********************************
*
* Init tables
*
********************************

sub InitTables()
  ubyte x
  uint x2
  int f
  uint f2
  float theta,temp

; First calculate sine table
; Table is f(x)=16*sin(x) where
; x=0..64 corresponds to 0..360

  sprint "sintab"
  for x=0:31
    theta = x/64.0 * 2.0*3.14159
    f = 0.5+256.0*16.0*sin(theta)
    ldx x
    lda f
    sta sintablo,x
    sta sintablo+64,x ;wraparound
    eor #$ff ;negative conversion
    clc               ;doesnt seem to work
    adc #$01 ;so do it by hand
    sta sintablo+32,x   ;negatives
    lda f+1
    sta sintabhi,x
    sta sintabhi+64,x
    eor #$ff
    adc #0
    sta sintabhi+32,x
;    sprint "."
  next
  sprintln

;
; Table of 1/x
;
; We use 32767/x to enable high
; accuracy down to x=1/2
;

  sprint "1/x"
  x=0
  repeat
    x++
    f2=32767.0/x+0.5
    ldx x
    lda f2
    sta invtablo,x
    lda f2+1
    sta invtabhi,x
  until x=255
  lda #255            ;max $7fff
  sta invtablo        ;65536/0
  sta invtabhi
  sprintln

;
; Projection table of d/z
;
; d=2048/x
;
  sprintln "d/z"
  x=0
  repeat
    x++
    temp=256.0*2048/x+0.5
    if temp > 65535.0
      temp=65535.0
    endif
    f2 = temp
    ldx x

    lda f2
    sta invzlo,x
    lda f2+1
    sta invzhi,x
  until x=255
    lda #255   ;just for completeness
    sta invzlo
    sta invzhi

;
; Fast multiply tables
;
  sprint "fastmult"
  x=0
  repeat
    f2=0.25*x*x+0.5
    ldx x
    lda #00
    sec
    sbc x             ;256-x
    tay
    lda f2
    sta multlo2,x     ;f(x)
    sta multlo1,y     ;f(-x)
    lda f2+1
    sta multhi2,x     ;f(x)
    sta multhi1,y     ;f(-x)

    f2 = 0.25*(x+256.0)*(x+256.0)+0.5
    ldx x
    lda f2
    sta multlo2+256,x
    lda f2+1
    sta multhi2+256,x

    x++
  until x=0 ;x is 8-bits
  sprintln

;
; Table of x*80/256, for getting the
; texture x-offset.
;

  ubyte k

  k=0
  repeat
    x2 = k*80
    ldx k
    lda x2+1           ;don't round
    sta xtextab,x
    k++
  until k=0

;
; Table of x*160, for getting the
; texture column offset in SuperRAM
;

  k=0
  repeat
    x2 = k*160
    ldx k
    lda x2
    sta lo160,x
    lda x2+1
    sta hi160,x
    k++
  until k=0

;
; Set up the map lookup table
;
; Map is organized as a 64x64 array
; in row,col order
;
imap
         ldy #00
         lda #00 ;low byte
         ldx #$c0     ;high byte
:l0      sta mapylo,y
         pha
         txa
         sta mapyhi,y
         pla
         clc
         adc #$40
         bcc :c0
         inx
:c0      iny
         cpy #64
         bcc :l0

  save"@0:tables5100-5fff",10,$5100,$5fff


endsub

*
* Initialize map
*
* The 64x64 map is stored in
* $c000-$cfff.
*
* The map is arranged in columns to
* enable easy traversal in the x- and
* y-directions using lda (zp),y with
* the x-coord stored in .y and the
* y-coord stored in zp as follows:
*
* y=0 x=0..63 $c000-$c03f
* y=1 x=0..63 $c100-$c13f
* ...
* y=15 x=0..63 $cf00-$cfff
* y=16 x=0..63 $c040-$c07f
* y=17 x=0..63 $c140-$c17f
* and so forth.
*

sub InitMap()

  fillmem($c000,$cfff,00)

imap
         ldy #00      ;y
         ldx #$c0     ;table hi
:c1      lda #00
         sta mapylo,y    ;y=0..15
         lda #$40
         sta mapylo+16,y ;y=16..31
         lda #$80
         sta mapylo+32,y ;y=32..47
         lda #$c0
         sta mapylo+48,y ;y=48..63
         txa
         sta mapyhi,y
         sta mapyhi+16,y
         sta mapyhi+32,y
         sta mapyhi+48,y
         iny
         inx
         cpx #$d0
         bne :c1

; Add a boundary around the edges

         lda #1
         sta :mapval  ;set edges to 1
         ldy #00      ;x-coord
:l1
         ldx #00 ;y-coord
         jsr :setmap
         ldx #63
         jsr :setmap
         iny
         cpy #64
         bne :l1

         ldx #1
:l2
         ldy #00 ;x-coord
         jsr :setmap
         ldy #63
         jsr :setmap
         inx
         cpx #63
         bne :l2

; Now put a few blocks in for testing

         lda #2
         sta :mapval
         ldy #5 ;x
         ldx #5       ;y
         jsr :setmap
         ldy #6
         ldx #5
         jsr :setmap
         ldy #7
         ldx #5
         jsr :setmap

         lda #3
         sta :mapval
         ldy #5
         ldx #6
         jsr :setmap
         ldy #5
         ldx #7
         jsr :setmap

         rts

:setmap
         lda mapylo,x
         sta zp
         lda mapyhi,x
         sta zp+1
         lda :mapval
         sta (zp),y
         rts
:mapval  dfb 00


;
; Initialize VLine routine
;
; Generate code like
;   tya
;   ora addr,x
;   sta addr,x
;
; and generate index tables into the
; code.
;
; We use two sets of code, one for
; x<128 and one for x>=128, offset
; by $0800.  Only one set of row
; index tables is needed but we use
; two to speed things up.
;
; This way is faster but takes up
; a lot of memory
;

buffer0 EQU $6000
buffer1 EQU $a000

Code1      equ $4000       ;actual code loc
Code1RowLo equ $4600  ;jump index
Code1RowHi equ $4700
Code2      equ $4800       ;x>128
Code2RowLo equ $4e00
Code2RowHi equ $4f00

Code3      equ $8000       ;actual code loc
Code3RowLo equ $8600  ;jump index
Code3RowHi equ $8700
Code4      equ $8800       ;x>128
Code4RowLo equ $8e00
Code4RowHi equ $8f00

bcode                 ;code snippet
         tya          ;copy to $c000
         ora $1234,x
         sta $1234,x
hcode
         tya
         ora $1234,x
         sta $1234,x

sub InitVLine()

  byte temp
  int zp1@$f7,zp2@$f9
  int addr

         jsr initbuf1

initbuf0 lda #<Code1
         sta zp1
         lda #>Code1
         sta zp1+1
         lda #<Code2
         sta zp2
         lda #>Code2
         sta zp2+1

         lda #<buffer0
         sta addr
         lda #>buffer0
         sta addr+1

         lda #8
         sta temp
         ldx #00
:genloop               ;Generate code
         lda addr
         sta bcode+2
         sta bcode+5
         sta hcode+2
         sta hcode+5
         lda addr+1
         sta bcode+3
         sta bcode+6
         clc
         adc #$01          ;256 offset
         sta hcode+3
         sta hcode+6

         lda zp1       ;...and tables
         sta Code1RowLo,x
         sta Code2RowLo,x
         lda zp1+1
         sta Code1RowHi,x
         ora #$08      ;$0800 offset
         sta Code2RowHi,x


         ldy #00
:l1      lda bcode,y  ;Copy code
         sta (zp1),y
         lda hcode,y
         sta (zp2),y
         iny
         cpy #7
         bne :l1
         tya          ;Advance zp
         clc
         adc zp1
         sta zp1
         sta zp2
         lda zp1+1
         adc #00
         sta zp1+1
         ora #$08     ;zp2 = zp1+$0800
         sta zp2+1
:c1
         inc addr     ;Increment row
         bne :c2      ;address
         inc addr+1
:c2
         dec temp     ;Increment every
         bne :c3  ;eight rows

         addr = addr+312
         lda #8
         sta temp

:c3      inx
         cpx #160
         bne :genloop
:exit
         lda #$60     ;last rts
         ldy #00
         sta (zp1),y
         sta (zp2),y

         lda zp1       ;entry points
         sta Code1RowLo,x
         lda zp1+1
         sta Code1RowHi,x
         lda zp2       ;entry points
         sta Code2RowLo,x
         lda zp2+1
         sta Code2RowHi,x
         rts

initbuf1 lda #<Code3
         sta zp1
         lda #>Code3
         sta zp1+1
         lda #<Code4
         sta zp2
         lda #>Code4
         sta zp2+1

         lda #<buffer1
         sta addr
         lda #>buffer1
         sta addr+1

         lda #8
         sta temp
         ldx #00
:genloop               ;Generate code
         lda addr
         sta bcode+2
         sta bcode+5
         sta hcode+2
         sta hcode+5
         lda addr+1
         sta bcode+3
         sta bcode+6
         clc
         adc #$01          ;256 offset
         sta hcode+3
         sta hcode+6

         lda zp1       ;...and tables
         sta Code3RowLo,x
         sta Code4RowLo,x
         lda zp1+1
         sta Code3RowHi,x
         ora #$08      ;$0800 offset
         sta Code4RowHi,x


         ldy #00
:l1      lda bcode,y  ;Copy code
         sta (zp1),y
         lda hcode,y
         sta (zp2),y
         iny
         cpy #7
         bne :l1
         tya          ;Advance zp
         clc
         adc zp1
         sta zp1
         sta zp2
         lda zp1+1
         adc #00
         sta zp1+1
         ora #$08     ;zp2 = zp1+$0800
         sta zp2+1
:c1
         inc addr     ;Increment row
         bne :c2      ;address
         inc addr+1
:c2
         dec temp     ;Increment every
         bne :c3  ;eight rows

         addr = addr+312
         lda #8
         sta temp

:c3      inx
         cpx #160
         bne :genloop
:exit
         lda #$60     ;last rts
         ldy #00
         sta (zp1),y
         sta (zp2),y

         lda zp1       ;entry points
         sta Code3RowLo,x
         lda zp1+1
         sta Code3RowHi,x
         lda zp2       ;entry points
         sta Code4RowLo,x
         lda zp2+1
         sta Code4RowHi,x
         rts


         put 'putcore.i.s'
