c64fILE
putcore.i.s






<{$fe}
]FAQ2     =   $69
]ACC      =   ]FAQ2   ;NOTE: hardcoded in sub asm core]ASCTONUM below
]AUX      =   ]ACC+2 ;to prevent phase errors
]EXT      =   ]AUX+2  ;update below if changing location
*ACC24    =   ACC
*AUX24    =   ACC+3
*EXT24    =   AUX24+3

BLNSW = $CC
BLNON = $CF
BLNCT = $CD

*
* INPUT inputs a string of data into STRBUF.  The maximum
* number of chars to be read are passed in X.  On output,
* zero set means the input was aborted with R/S or is
* empty.  .A (and STRLEN) contains the string length.
*
STRBUF EQU $0200
STRLEN ;ENT
         DFB 00
MAXLEN DFB 00

core]INPUT
 LDA #00
 STA STRBUF
 STA STRLEN
 STX MAXLEN
 LDA $0286 ;Set blink color to
 STA $0287 ;current color.

:LOOP    LDA #1
 STA BLNCT
 LDA #00
 STA BLNSW ;Blink
:W LDA BLNON
         BNE :W       ;Wait for one blink

:WAIT    JSR $FFE4 ;GETIN
 BNE :BLOFF
         JSR $FFE1 ;STOP
 BNE :WAIT
 LDA #00
:BLOFF LDY #1
 STY BLNCT
:WAIT2 LDY BLNON
 BEQ :WAIT2
 INC BLNSW

 TAY
 BEQ :RTS
 CMP #160 ;Alphanumeric characters
 BCS :NORMAL
 CMP #147
 BEQ :CLR
 CMP #128
 BCS :LOOP
 CMP #13
 BEQ :DONE
 CMP #20
 BEQ :DEL
 CMP #32
 BCC :LOOP
:NORMAL
 LDY STRLEN
 CPY MAXLEN
 BCS :LOOP
 STA STRBUF,Y
         JSR $FFD2
 INC STRLEN
 BNE :LOOP

:CLR LDY STRLEN
 BEQ :LOOP
 LDA #20
:L2      JSR $FFD2
 DEC STRLEN
 BNE :L2
 BEQ :LOOP

:DEL LDY STRLEN
 BEQ :LOOP
 LDA #157
         JSR $FFD2
 LDA #32
         JSR $FFD2
         LDA #157
         JSR $FFD2
 DEC STRLEN
 BPL :LOOP

:DONE LDY STRLEN
 LDA #00
 STA STRBUF,Y
 TYA ;Z set if string empty
:RTS RTS

*
* PRINT
*   As the name suggests, this prints a string to the
*   screen, where the address of the string is
*   contained in (.X,.A) = (lo,hi).  The string is
*   assumed to be null-terminated.
*
*   On exit, the location of the last character read
*   (the null-terminator hopefully) is returned in
*   (.X,.A) = (lo,hi).  Y is preserved.
*
core]PRINT
 STA :LOOP+2
:LOOP LDA $A000,X
 BEQ :DONE
         JSR $FFD2
 INX
 BNE :LOOP
 INC :LOOP+2
 BNE :LOOP
:DONE
 LDA :LOOP+2
 RTS

*
* STROUT
*   Like PRINT, but the string immediately follows the
*   subroutine call; execution resumes right after the
*   null-termination byte.
*
*   On exit, A and X are thoroughly hosed.
*
core]STROUT
 PLA
 TAX ;Lo byte
 PLA
         INX
 BNE :CONT
 CLC
 ADC #01
:CONT    JSR core]PRINT
 PHA ;hi byte
 TXA
 PHA ;lo byte
         RTS


*-------------------------------------
* 16 bit multiply and divide routines.
* Three 16 bit (two-byte) locations
* ACC, AUX and EXT must be set up,
* preferably on zero page.
*-------------------------------------

* MULTIPLY ROUTINE

* ACC*AUX -> [ACC,EXT] (low,hi) 32 bit result

core]]MULT16
 LDA #0
         STA ]EXT+1
 LDY #$11
 CLC
:LOOP    ROR ]EXT+1
 ROR
         ROR ]ACC+1
         ROR ]ACC
 BCC :MUL2
 CLC
         ADC ]AUX
 PHA
         LDA ]AUX+1
         ADC ]EXT+1
         STA ]EXT+1
 PLA
:MUL2 DEY
 BNE :LOOP
         STA ]EXT
         RTS


* DIVIDE ROUTINE

* ACC/AUX -> ACC, remainder in EXT

core]]DIV16
 LDA #0
         STA ]EXT+1
 LDY #$10
:LOOP    ASL ]ACC
         ROL ]ACC+1
 ROL
         ROL ]EXT+1
 PHA
         CMP ]AUX
         LDA ]EXT+1
         SBC ]AUX+1
 BCC :DIV2
         STA ]EXT+1
 PLA
         SBC ]AUX
 PHA
         INC ]ACC
:DIV2 PLA
 DEY
         BNE :LOOP
         STA ]EXT
 RTS

*
* ASCTONUM
*   Converts a string to a 16-bit number.  The address
*   of the string is passed in in (A,X) = (lo,hi), and
*   the base of the number is contained in Y.  Valid
*   bases are 0-16.  The string is assumed to be
*   null-terminated.
*
*   On exit, carry set denotes an error, either an
*   invalid base, an invalid string, or a number
*   overflow.  The number is contained in ACC, as
*   used in MULT16.  The last char read is contained
*   in (A,X)=(lo,hi).  Y is toast.
*
core]]ASCTONUM
 CPY #17
 BCS :EXIT
 STY ]AUX ;AUX=number base
 LDY #00
 STY ]AUX+1
 STY ]ACC
 STY ]ACC+1
 STX :LOOP+2
 TAX ;X=lo byte string

:LOOP LDA $A000,X ;Valid chars are $30-$39, $41-$46
 BEQ :EXIT
 EOR #$30
 CMP #10
 BCC :CONT
 EOR #$70 ;Should use SBC #$70-9
 ADC #8 ;Now A-F = 10-16
:CONT CMP ]AUX ;Compare with number base
 BCS :EXIT
 PHA
 JSR core]]MULT16 ;Multiply number times base
 PLA
 LDY ]EXT ;Did multiplication exceed 16 bits?
 BNE :ERROR
 CLC
 ADC ]ACC
 STA ]ACC
 LDA ]ACC+1
 ADC #00
 STA ]ACC+1
 INX
 BNE :LOOP
 INC :LOOP+2
 BNE :LOOP
:ERROR SEC
:EXIT TXA
 LDX :LOOP+2
 RTS

*
* PRINTNUM
*   Prints the 16-bit number in (A,X) = (lo,hi)
*   to the screen, i.e. prints using CHROUT.
*   The number base is contained in Y.
*
]MINDIGITS DFB 00

core]PrintSigned0
 ldy #10
core]PrintSigned
 cpx #$80
*         bcc ]PrintNum
         bcc :print
 eor #$ff
 adc #00
 pha
 txa
 eor #$ff
 adc #00
 tax
 lda #'-'
 jsr $ffd2
         pla
:print dfb $2c
core]PrintNum0
 ldy #10
core]PrintNum
         STA ]ACC
         STX ]ACC+1
         STY ]AUX      ;Base
 LDX #00
         STX ]AUX+1
* ACC/AUX -> ACC, remainder in EXT
:LOOP    JSR core]]DIV16
 INX
         LDA ]EXT
         PHA
 DEC ]MINDIGITS
 LDA ]ACC
         ORA ]ACC+1
         BNE :LOOP    ;Divide until result=0
:L1 DEC ]MINDIGITS
 BMI :POOP
 LDA #'0' ;positive numbers only
 JSR $FFD2
 BNE :L1
:POOP PLA
 ORA #$30 ;Convert to chr$
 CMP #$3A
 BCC :PLOP
 ADC #$06 ;$3A->A $3B->B etc.
:PLOP    JSR $FFD2
 DEX
         BNE :POOP
 LDA #00 ;always reset
 STA ]MINDIGITS
 RTS

*
* PRHEX
*   Print a hex byte in .A, including trailing zeros
*
core]PRHEX
 PHA
 LSR
 LSR
 LSR
 LSR
 JSR :PRINT
 PLA
 AND #$0F
:PRINT ORA #$30
 CMP #$3A
 BCC :PLOP
 ADC #$06
:PLOP    JMP $FFD2

********************************
*
* Slang routines
*
********************************

*
* Read a float.
*
* Should update: leave in fac1, since
* it will be copied somewhere anyways.
* The reason it's moved to mem is for
* 5-byte conversion.
*
sub core]ReadFloat()_float x
  uint txtptr@$007a

  core]InputStr(20)
  lda STRBUF          ;check for -
  cmp #'-'
  beq :neg
  txtptr=#core]InputStr_buffer
  jsr $0079
  jsr $bcf3
  jmp :done
:neg
  txtptr=#core]InputStr_buffer+1
  jsr $0079
  jsr $bcf3
  lda #$ff
  sta $66

:done
  ldx #<x
  ldy #>x
  jsr $bbd4           ;move to x
endsub

*
* Read a 16-bit int, with a little
* parsing to allow hex, bin, neg.
*
* On exit:
*   C set -> error (number conversion)
*   .AX = pointer to last char+1
*
sub core]ReadInt()_int x
  ubyte base,neg

  core]InputStr(20)
  beq :abort

 ldx #00
 stx neg
:l1 lda STRBUF,x ;check leading chars
 cmp #'-'
         bne :c1
 lda neg ;sure what the heck
 eor #1 ;allow --3
 sta neg
 inx
 bne :l1
:c1 cmp #'$'
 beq :16
 cmp #'%'
 bne :ten
 ldy #2
 dfb $2c
:16      ldy #16
 inx
 dfb $2c
:ten ldy #10 ;base
 txa
 clc
 adc #<STRBUF
 pha
 lda #>STRBUF
 adc #00
 tax ;hi
 pla ;lo
         core]ASCTONUM()
 ldy neg
 beq :pos
:neg pha
 x = -core]ASCTONUM_x
         pla
         clc
         rts
:pos
 pha
         x = core]ASCTONUM_x
         pla
         rts
:abort
 pha
 lda #00
 sta x
 sta x+1
 pla
 sec
endsub


sub asm PrHex@core]PRHEX(@a)
sub asm PrintNum@core]printnum(ubyte a@]MINDIGITS, @y, @ax) ;PrintNum(digits, base, number)
sub asm PrintSignedNum@core]printsigned(ubyte a@]MINDIGITS, @y, @ax)

;
; These next two just use the default
; minbytes=0, base=10 for simplified
; use by PRINT
;
sub asm PrintNum0@core]printnum0(@ax) ;PrintNum(digits, base, number)
sub asm PrintSignedNum0@core]printsigned0(@ax)

sub asm core]InputStr@core]INPUT(@x)_uint buffer@STRBUF ;InputStr(maxchars)
sub asm core]AscToNum@core]]ASCTONUM(@ax,@y)_uint x@$69 ;ACC=$69

sub asm core]mult16@core]]MULT16( &
    uint acc@$69, uint aux@$6b)_ &
    uint lo@$69, uint hi@$6d

sub asm core]div16@core]]DIV16( &
    uint acc@$69, uint aux@$6b)_ &
    uint lo@$69, uint rem@$6d

sub core]printlib()
  lda #1              ;version
endsub


